unit stylesb;

interface

uses
  Classes, Graphics, Messages, Controls, Buttons;

type
  TStyleSpeedButtonStyle = (bsAutoDetect, bsWin31, bsWin95, bsWin97);
  TStyleSpeedButton = class(TSpeedButton)
  private
    MouseOver: Boolean;
    FStyle: TStyleSpeedButtonStyle;
    procedure SetStyle(Value: TStyleSpeedButtonStyle);
  protected
    procedure DrawDownExclFrame;
    procedure DrawDisabledFrame;
    procedure CMMOUSEENTER(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMOUSELEAVE(var Message: TMessage); message CM_MOUSELEAVE;
    procedure Paint; override;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property Style: TStyleSpeedButtonStyle read FStyle write SetStyle default bsAutoDetect;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Additional', [TStyleSpeedButton]);
end;

procedure TStyleSpeedButton.SetStyle(Value: TStyleSpeedButtonStyle);
begin
  if Value <> FStyle then
  begin
    FStyle := Value;
    Invalidate;
  end;
end;

constructor TStyleSpeedButton.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  SetBounds(0, 0, 23, 22);
  MouseOver := False;
  FStyle := bsAutoDetect;
end;

procedure TStyleSpeedButton.DrawDownExclFrame;
begin
  with canvas do
  begin
    Pen.Color := clBtnShadow;
    PolyLine([Point(0, Height-2), Point(0, 0), Point(Width-1, 0)] );
    Pen.Color := clBtnFace;
    PolyLine([Point(1, Height-2), Point(1, 1), Point(Width-1, 1)] );
    PolyLine([Point(1, Height-2), Point(Width-2, Height-2), Point(Width-2, 0)] );
    Pen.Color := clBtnHighLight;
    PolyLine([Point(0, Height-1), Point(Width-1, Height-1), Point(Width-1, -1)] );
  end;
end;

procedure TStyleSpeedButton.DrawDisabledFrame;
begin
  with canvas do
  begin
    Pen.Color := clBtnFace;
    PolyLine([Point(0, Height-2), Point(0, 0), Point(Width-1, 0)] );
    PolyLine([Point(1, Height-2), Point(1, 1), Point(Width-1, 1)] );
    PolyLine([Point(1, Height-2), Point(Width-2, Height-2), Point(Width-2, 0)] );
    PolyLine([Point(0, Height-1), Point(Width-1, Height-1), Point(Width-1, -1)] );
  end;
end;

procedure TStyleSpeedButton.Paint;
begin
  inherited Paint;
  if FStyle = bsWin97 then
  begin
    with canvas do
    begin
      if FState = bsUp then
      begin
        if (csDesigning in ComponentState) or (MouseOver) then
        begin
          Pen.Color := clBtnHighLight;
          PolyLine([Point(0, Height-2), Point(0, 0), Point(Width-1, 0)] );
          Pen.Color := clBtnFace;
          PolyLine([Point(1, Height-2), Point(1, 1), Point(Width-1, 1)] );
          PolyLine([Point(1, Height-2), Point(Width-2, Height-2), Point(Width-2, 0)] );
          Pen.Color := clBtnShadow;
          PolyLine([Point(0, Height-1), Point(Width-1, Height-1), Point(Width-1, -1)] );
        end else DrawDisabledFrame;
      end;
      if FState = bsExclusive then
      begin
        if (csDesigning in ComponentState) or (MouseOver) then DrawDownExclFrame else
          DrawDisabledFrame;
      end;
      if FState = bsDown then DrawDownExclFrame;
      if FState = bsDisabled then DrawDisabledFrame;
    end;
  end else
  if ((FStyle = bsAutodetect) and (NewStyleControls)) or (FStyle = bsWin95) then
  begin
    with canvas do
    begin
      if FState in [bsDown, bsExclusive] then
      begin
        Pen.Color := clBtnHighLight;
        PolyLine([Point(0, Height-1), Point(Width-1, Height-1), Point(Width-1, -1)] );
        PolyLine([Point(1, Height-2), Point(Width-2, Height-2), Point(Width-2, 0)] );
      end else
      begin
        Pen.Color := clBtnHighLight;
        PolyLine([Point(0, Height-2), Point(0, 0), Point(Width-1, 0)] );
        PolyLine([Point(1, Height-3), Point(1, 1), Point(Width-2, 1)] );
      end;
    end;
  end else
  if ((FStyle = bsAutodetect) and (not NewStyleControls)) or (FStyle = bsWin31) then
  begin
    with canvas do
    begin
      if FState in [bsDown, bsExclusive] then
      begin
        Pen.Color := clBlack;
        PolyLine([Point(1, Height-1), Point(Width-1, Height-1), Point(Width-1, 0)] );
        Pixels[0, 0] := clBtnFace;
        Pixels[Width-1, 0] := clBtnFace;
        Pixels[0, Height-1] := clBtnFace;
        Pixels[Width-1, Height-1] := clBtnFace;
      end else
      begin
        Pen.Color := clBlack;
        PolyLine([Point(1, 0), Point(Width-1, 0)] );
        PolyLine([Point(0, 1), Point(0, Height-1)] );
        Pixels[0, 0] := clBtnFace;
        Pixels[Width-1, 0] := clBtnFace;
        Pixels[0, Height-1] := clBtnFace;
        Pixels[Width-1, Height-1] := clBtnFace;
        Pen.Color := clBtnHighLight;
        PolyLine([Point(1, Height-3), Point(1, 1), Point(Width-2, 1)] );
        Pen.Color := clBtnShadow;
        PolyLine([Point(2, Height-3), Point(Width-3, Height-3), Point(Width-3, 1)] );
      end;
    end;
  end;
end;

procedure TStyleSpeedButton.CMMOUSEENTER(var Message: TMessage);
begin
  MouseOver := True;
  if (not Dragging) and (Enabled) and (FStyle = bsWin97) then Repaint;
  inherited;
end;

procedure TStyleSpeedButton.CMMOUSELEAVE(var Message: TMessage);
begin
  MouseOver := False;
  if (Down) and (FState = bsUp) then FState := bsExclusive;
  if (not Dragging) and (Enabled) and (FStyle = bsWin97) then Repaint;
  inherited;
end;

end.

